/*
 * Decompiled with CFR 0.152.
 */
package launcher;

import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.FloatBuffer;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import launcher.Runnit;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCursorPosCallbackI;
import org.lwjgl.glfw.GLFWFramebufferSizeCallback;
import org.lwjgl.glfw.GLFWFramebufferSizeCallbackI;
import org.lwjgl.glfw.GLFWKeyCallbackI;
import org.lwjgl.glfw.GLFWMouseButtonCallbackI;
import org.lwjgl.glfw.GLFWScrollCallbackI;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import slick.Audio;
import slick.AudioLoader;
import slick.ColorSlick;
import slick.Inputs;
import slick.Matrix4f;
import slick.ResourceLoader;
import slick.SoundStore;
import slick.Texture;
import slick.TextureLoader;
import slick.TrueTypeFont;
import slick.Vector3f;

public class LauncherCode {
    public String version_string = "2.5-VR";
    public int screen_width = 1000;
    public int screen_height = 600;
    public String windowTitle = "DangerZone Launcher";
    public Font awtfont = null;
    public TrueTypeFont font = null;
    public Font smallawtfont = null;
    public TrueTypeFont smallfont = null;
    private Texture logotexture = null;
    private Texture buttontexture = null;
    private Texture runbuttontexture = null;
    private Texture checktexture = null;
    private Texture unchecktexture = null;
    private Texture textinputtexture = null;
    private Texture[] pics;
    public boolean quit = false;
    public List<ButtonHandler> buttons;
    public boolean escaped = false;
    public boolean entered = false;
    public Properties prop = new Properties();
    public int picnum = 0;
    public int picnum_counter = 0;
    public int errstringcounter = 0;
    public int client_max_g = 2;
    public int single_max_g = 2;
    public int server_max_g = 2;
    public String server_address = "127.0.0.1";
    public int server_port = 18668;
    public int nsserver_port = 18669;
    public String server_port_string = "";
    public String worldname = "my_world";
    public String playername = "Player";
    public String playerpassword = "";
    public String alt_texture_path = "";
    public int current_screen = 0;
    public Iterator<ButtonHandler> bb;
    public Audio popsound;
    public boolean playernameinput = false;
    public boolean serveraddressinput = false;
    public boolean newworldinput = false;
    public boolean serverportinput = false;
    public boolean passwordinput = false;
    public int worldliststart = 0;
    public int numworld = 0;
    public boolean displaydeleteconfirm = false;
    public boolean dodelete = false;
    public String newworldname = "New World";
    public String crypted_password = null;
    public String errstring = null;
    private final Class[] parameters = new Class[]{URL.class};
    public String playerstatestring = "unknown";
    public volatile boolean do_validate = false;
    public volatile boolean name_registered_already = false;
    public volatile boolean do_register = false;
    public boolean world_loaded = false;
    public String worldfile = "";
    public boolean generatecaves = true;
    public boolean playnicely = false;
    public boolean require_valid_passwords = true;
    public long worldseed = 0L;
    public boolean keep_inventory_on_death = false;
    public int timetimer = 0;
    public String todinputstring = "";
    public boolean todinput = false;
    public int max_players_on_server = 0;
    public String maxpinputstring = "";
    public boolean maxpinput = false;
    public int default_privs = 0;
    public String privsinputstring = "";
    public boolean privsinput = false;
    public int login_state = 0;
    private long window;
    public Inputs input;
    GLFWFramebufferSizeCallback fbCallback;
    private long monitor = 0L;
    int dl = -1;
    int gridSize = 40;
    float ceiling = 3.0f;

    public void startGUI() {
        this.input = new Inputs(1000, 600);
        GLFW.glfwInit();
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint((int)131075, (int)0);
        GLFW.glfwWindowHint((int)131076, (int)1);
        this.monitor = GLFW.glfwGetPrimaryMonitor();
        GLFWVidMode vidMode = GLFW.glfwGetVideoMode((long)this.monitor);
        this.window = GLFW.glfwCreateWindow((int)this.input.getScreenWidth(), (int)this.input.getScreenHeight(), (CharSequence)"DangerZone Launcher :: LWJGL3", (long)0L, (long)0L);
        if (this.window == 0L) {
            throw new RuntimeException("Failed to create window");
        }
        GLFW.glfwSetKeyCallback((long)this.window, (GLFWKeyCallbackI)this.input.getKeyboardCallback());
        GLFW.glfwSetCursorPosCallback((long)this.window, (GLFWCursorPosCallbackI)this.input.getMouseMoveCallback());
        GLFW.glfwSetMouseButtonCallback((long)this.window, (GLFWMouseButtonCallbackI)this.input.getMouseButtonsCallback());
        GLFW.glfwSetFramebufferSizeCallback((long)this.window, (GLFWFramebufferSizeCallbackI)this.input.getFrameSizeCallback());
        GLFW.glfwSetScrollCallback((long)this.window, (GLFWScrollCallbackI)this.input.getScrollCallback());
        GLFW.glfwSetWindowPos((long)this.window, (int)((vidMode.width() - this.input.getScreenWidth()) / 2), (int)((vidMode.height() - this.input.getScreenHeight()) / 2));
        GLFW.glfwSetInputMode((long)this.window, (int)208897, (int)212995);
        GLFW.glfwMakeContextCurrent((long)this.window);
        GLFW.glfwSwapInterval((int)0);
        GLFW.glfwShowWindow((long)this.window);
        GL.createCapabilities();
        GL11.glClearColor((float)0.97f, (float)0.97f, (float)0.97f, (float)1.0f);
        GLFW.glfwWindowHint((int)131076, (int)1);
        try {
            SoundStore.get().init();
        }
        catch (Exception e1) {
            System.out.printf("Something went horribly wrong with initialization!\n", new Object[0]);
            e1.printStackTrace();
            System.exit(1);
        }
    }

    public void stopGUI() {
        GLFW.glfwDestroyWindow((long)this.window);
        GLFW.glfwTerminate();
        this.input.destroy();
    }

    public void launcher_main(String[] args) throws InterruptedException, IOException {
        String curdir;
        File libfile;
        Random rand = new Random();
        rand.setSeed(System.currentTimeMillis());
        if (Locale.getDefault() != Locale.US) {
            Locale.setDefault(Locale.US);
        }
        if ((libfile = new File(String.valueOf(curdir = System.getProperty("user.dir")) + "/DangerZone_lib/native")).exists()) {
            System.setProperty("org.lwjgl.librarypath", String.valueOf(curdir) + "/DangerZone_lib/native");
        }
        CodeSource codeSource = LauncherCode.class.getProtectionDomain().getCodeSource();
        try {
            File myfile = new File(codeSource.getLocation().toURI().getPath());
            this.addFile(myfile);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.startGUI();
        this.awtfont = new Font("Times New Roman", 0, 36);
        this.font = new TrueTypeFont(this.awtfont, false);
        this.smallawtfont = new Font("Times New Roman", 0, 24);
        this.smallfont = new TrueTypeFont(this.smallawtfont, false);
        try {
            this.logotexture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("launchres/menus/logo.png"));
            this.buttontexture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("launchres/menus/button.png"));
            this.runbuttontexture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("launchres/menus/runbutton.png"));
            this.checktexture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("launchres/menus/check.png"));
            this.unchecktexture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("launchres/menus/uncheck.png"));
            this.textinputtexture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("launchres/menus/textinput.png"));
            this.pics = new Texture[17];
            int i = 0;
            while (i < 17) {
                this.pics[i] = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream(String.format("launchres/menus/pic%d.png", i + 1)));
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.popsound = AudioLoader.getAudio("WAV", ResourceLoader.getResourceAsStream("launchres/sounds/pop.wav"));
        }
        catch (Exception e) {
            this.popsound = null;
        }
        this.readConfig();
        this.picnum = 0;
        this.picnum_counter = 0;
        float heightAboveGround = 0.0f;
        Vector3f dir = new Vector3f();
        Vector3f right = new Vector3f();
        Matrix4f mat = new Matrix4f();
        FloatBuffer fb = BufferUtils.createFloatBuffer(16);
        Vector3f pos = new Vector3f(0.0f, heightAboveGround, 0.0f);
        float rotX = 0.0f;
        float rotY = 0.0f;
        dir.x = 1.0f;
        right.z = 1.0f;
        GL11.glMatrixMode((int)5889);
        GL11.glLoadMatrixf((FloatBuffer)mat.setPerspective((float)Math.toRadians(45.0), (float)this.input.getScreenWidth() / (float)this.input.getScreenHeight(), 1.0f, 100.0f, false).get(fb));
        GL11.glMatrixMode((int)5888);
        mat.identity().rotateX(rotX).rotateY(rotY);
        GL11.glLoadMatrixf((FloatBuffer)mat.get(fb));
        GL11.glViewport((int)0, (int)0, (int)this.input.getScreenWidth(), (int)this.input.getScreenHeight());
        GL11.glClear((int)16384);
        GL11.glTranslatef((float)pos.x, (float)pos.y, (float)pos.z);
        GL11.glDisable((int)2929);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.input.getScreenWidth(), (double)0.0, (double)this.input.getScreenHeight(), (double)-30.0, (double)30.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.showLogo();
        GLFW.glfwSwapBuffers((long)this.window);
        this.textAt(25.0f, this.screen_height - 50, "Hi " + this.playername + "!");
        this.textAt(675.0f, this.screen_height - 50, "Launcher Ver " + this.version_string);
        this.do_validate = true;
        Thread.sleep(1000L);
        this.picnum = rand.nextInt(17) + 1;
        GLFW.glfwSetInputMode((long)this.window, (int)208897, (int)212993);
        while (!this.quit) {
            GL11.glMatrixMode((int)5889);
            GL11.glLoadMatrixf((FloatBuffer)mat.setPerspective((float)Math.toRadians(45.0), (float)this.input.getScreenWidth() / (float)this.input.getScreenHeight(), 1.0f, 100.0f, false).get(fb));
            GL11.glMatrixMode((int)5888);
            mat.identity().rotateX(rotX).rotateY(rotY);
            GL11.glLoadMatrixf((FloatBuffer)mat.get(fb));
            GL11.glViewport((int)0, (int)0, (int)this.input.getScreenWidth(), (int)this.input.getScreenHeight());
            GL11.glClear((int)16384);
            GL11.glTranslatef((float)pos.x, (float)pos.y, (float)pos.z);
            GL11.glDisable((int)2929);
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            GL11.glOrtho((double)0.0, (double)this.input.getScreenWidth(), (double)0.0, (double)this.input.getScreenHeight(), (double)-30.0, (double)30.0);
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            if (this.errstring != null && this.errstringcounter == 0) {
                this.errstringcounter = 100;
            }
            if (this.errstringcounter > 0) {
                --this.errstringcounter;
                if (this.errstringcounter == 0) {
                    this.errstring = null;
                }
            }
            ++this.picnum_counter;
            if (this.picnum_counter > 250) {
                this.picnum_counter = 0;
                this.picnum = rand.nextInt(17) + 1;
            }
            this.showLogo();
            if (this.current_screen == 0) {
                this.doHomeScreen();
            }
            if (this.current_screen == 1) {
                this.doMultiPlayerScreen();
            }
            if (this.current_screen == 2) {
                this.doOptionsScreen();
            }
            if (this.current_screen == 3) {
                this.doSinglePlayerScreen();
            }
            if (this.current_screen == 4) {
                this.doMusicScreen();
            }
            if (this.current_screen == 5) {
                this.doWorldEditScreen();
            }
            if (this.current_screen == 6) {
                this.doRegisterConfirm();
            }
            GLFW.glfwSwapBuffers((long)this.window);
            Thread.sleep(20L);
            this.quit = GLFW.glfwWindowShouldClose((long)this.window);
            if (this.input.isKeyDown(256)) {
                this.quit = true;
            }
            if (this.quit) break;
            SoundStore.get().poll(0);
            GLFW.glfwPollEvents();
        }
        GLFW.glfwSetInputMode((long)this.window, (int)208897, (int)212995);
        this.picnum = 0;
        this.showLogo();
        this.textAt(10.0f, 10.0f, "Bye!");
        GLFW.glfwSwapBuffers((long)this.window);
        this.writeConfig();
        Thread.sleep(1000L);
        SoundStore.get().clear();
        this.stopGUI();
        System.exit(0);
    }

    void renderGrid() {
        if (this.dl == -1) {
            this.dl = GL11.glGenLists((int)1);
            GL11.glNewList((int)this.dl, (int)4864);
            GL11.glBegin((int)1);
            GL11.glColor3f((float)0.2f, (float)0.2f, (float)0.2f);
            int i = -this.gridSize;
            while (i <= this.gridSize) {
                GL11.glVertex3f((float)(-this.gridSize), (float)0.0f, (float)i);
                GL11.glVertex3f((float)this.gridSize, (float)0.0f, (float)i);
                GL11.glVertex3f((float)i, (float)0.0f, (float)(-this.gridSize));
                GL11.glVertex3f((float)i, (float)0.0f, (float)this.gridSize);
                ++i;
            }
            GL11.glColor3f((float)0.5f, (float)0.5f, (float)0.5f);
            i = -this.gridSize;
            while (i <= this.gridSize) {
                GL11.glVertex3f((float)(-this.gridSize), (float)this.ceiling, (float)i);
                GL11.glVertex3f((float)this.gridSize, (float)this.ceiling, (float)i);
                GL11.glVertex3f((float)i, (float)this.ceiling, (float)(-this.gridSize));
                GL11.glVertex3f((float)i, (float)this.ceiling, (float)this.gridSize);
                ++i;
            }
            GL11.glEnd();
            GL11.glEndList();
        }
        GL11.glCallList((int)this.dl);
    }

    private void showLogo() {
        GL11.glPushMatrix();
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClear((int)16640);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.picnum == 0) {
            this.logotexture.bind();
        } else {
            this.pics[this.picnum - 1].bind();
        }
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        float x = 210.0f;
        float y = 200.0f;
        if (this.picnum > 0) {
            x = 480.0f;
            y = 280.0f;
        }
        GL11.glTranslatef((float)(this.input.getScreenWidth() / 2), (float)(this.input.getScreenHeight() / 2), (float)-5.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)x, (float)y, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)(-x), (float)y, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)(-x), (float)(-y), (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)x, (float)(-y), (float)0.0f);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public void textAt(float xpos, float ypos, String text) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)xpos, (float)(ypos + (float)this.font.getHeight()), (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.font.drawString(0.0f, 0.0f, text, ColorSlick.white);
        GL11.glPopMatrix();
    }

    public void smalltextAt(float xpos, float ypos, String text) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)xpos, (float)(ypos + (float)this.smallfont.getHeight()), (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.smallfont.drawString(0.0f, 0.0f, text, ColorSlick.white);
        GL11.glPopMatrix();
    }

    public void errtextAt(float xpos, float ypos, String text) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)xpos, (float)(ypos + (float)this.font.getHeight()), (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.font.drawString(0.0f, 0.0f, text, ColorSlick.red);
        GL11.glPopMatrix();
    }

    public void drawRectangleWithTexture(Texture t, float xpos, float ypos, float xsize, float ysize) {
        float w = t.getWidth();
        float h = t.getHeight();
        t.bind();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)xpos, (float)ypos, (float)0.0f);
        GL11.glScalef((float)(xsize / t.getWidth()), (float)(ysize / t.getHeight()), (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)w, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)h);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)w, (float)h);
        GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public String getTextChar() {
        boolean caps = false;
        this.escaped = false;
        this.entered = false;
        if (this.input.isKeyDown(340) || this.input.isKeyDown(344)) {
            caps = true;
        }
        while (this.input.hasNextKey()) {
            int currk;
            Inputs.KeyEvent ke = this.input.nextKey();
            if (ke.key == 256 && this.input.isKeyDown(256)) {
                this.escaped = true;
            }
            if (ke.key == 257 && this.input.isKeyDown(257)) {
                this.entered = true;
            }
            if (!this.input.isKeyDown(currk = ke.key)) continue;
            switch (currk) {
                case 261: {
                    return "delete";
                }
                case 259: {
                    return "delete";
                }
                case 48: {
                    if (caps) {
                        return ")";
                    }
                    return "0";
                }
                case 49: {
                    if (caps) {
                        return "!";
                    }
                    return "1";
                }
                case 50: {
                    if (caps) {
                        return "@";
                    }
                    return "2";
                }
                case 51: {
                    if (caps) {
                        return "#";
                    }
                    return "3";
                }
                case 52: {
                    if (caps) {
                        return "$";
                    }
                    return "4";
                }
                case 53: {
                    if (caps) {
                        return "%";
                    }
                    return "5";
                }
                case 54: {
                    if (caps) {
                        return "^";
                    }
                    return "6";
                }
                case 55: {
                    if (caps) {
                        return "&";
                    }
                    return "7";
                }
                case 56: {
                    if (caps) {
                        return "*";
                    }
                    return "8";
                }
                case 57: {
                    if (caps) {
                        return "(";
                    }
                    return "9";
                }
                case 65: {
                    if (caps) {
                        return "A";
                    }
                    return "a";
                }
                case 66: {
                    if (caps) {
                        return "B";
                    }
                    return "b";
                }
                case 67: {
                    if (caps) {
                        return "C";
                    }
                    return "c";
                }
                case 68: {
                    if (caps) {
                        return "D";
                    }
                    return "d";
                }
                case 69: {
                    if (caps) {
                        return "E";
                    }
                    return "e";
                }
                case 70: {
                    if (caps) {
                        return "F";
                    }
                    return "f";
                }
                case 71: {
                    if (caps) {
                        return "G";
                    }
                    return "g";
                }
                case 72: {
                    if (caps) {
                        return "H";
                    }
                    return "h";
                }
                case 73: {
                    if (caps) {
                        return "I";
                    }
                    return "i";
                }
                case 74: {
                    if (caps) {
                        return "J";
                    }
                    return "j";
                }
                case 75: {
                    if (caps) {
                        return "K";
                    }
                    return "k";
                }
                case 76: {
                    if (caps) {
                        return "L";
                    }
                    return "l";
                }
                case 77: {
                    if (caps) {
                        return "M";
                    }
                    return "m";
                }
                case 78: {
                    if (caps) {
                        return "N";
                    }
                    return "n";
                }
                case 79: {
                    if (caps) {
                        return "O";
                    }
                    return "o";
                }
                case 80: {
                    if (caps) {
                        return "P";
                    }
                    return "p";
                }
                case 81: {
                    if (caps) {
                        return "Q";
                    }
                    return "q";
                }
                case 82: {
                    if (caps) {
                        return "R";
                    }
                    return "r";
                }
                case 83: {
                    if (caps) {
                        return "S";
                    }
                    return "s";
                }
                case 84: {
                    if (caps) {
                        return "T";
                    }
                    return "t";
                }
                case 85: {
                    if (caps) {
                        return "U";
                    }
                    return "u";
                }
                case 86: {
                    if (caps) {
                        return "V";
                    }
                    return "v";
                }
                case 87: {
                    if (caps) {
                        return "W";
                    }
                    return "w";
                }
                case 88: {
                    if (caps) {
                        return "X";
                    }
                    return "x";
                }
                case 89: {
                    if (caps) {
                        return "Y";
                    }
                    return "y";
                }
                case 90: {
                    if (caps) {
                        return "Z";
                    }
                    return "z";
                }
                case 46: {
                    if (caps) {
                        return ">";
                    }
                    return ".";
                }
                case 44: {
                    if (caps) {
                        return "<";
                    }
                    return ",";
                }
                case 47: {
                    if (caps) {
                        return "?";
                    }
                    return "/";
                }
                case 59: {
                    if (caps) {
                        return ":";
                    }
                    return ";";
                }
                case 39: {
                    if (caps) {
                        return "\"";
                    }
                    return "'";
                }
                case 32: 
                case 258: {
                    return " ";
                }
                case 92: {
                    if (caps) {
                        return "|";
                    }
                    return "\\";
                }
                case 91: {
                    if (caps) {
                        return "{";
                    }
                    return "[";
                }
                case 93: {
                    if (caps) {
                        return "}";
                    }
                    return "]";
                }
                case 45: {
                    if (caps) {
                        return "_";
                    }
                    return "-";
                }
                case 61: {
                    if (caps) {
                        return "+";
                    }
                    return "=";
                }
            }
        }
        return null;
    }

    public String getNumericChar() {
        this.escaped = false;
        this.entered = false;
        while (this.input.hasNextKey()) {
            int currk;
            Inputs.KeyEvent ke = this.input.nextKey();
            if (ke.key == 256 && this.input.isKeyDown(256)) {
                this.escaped = true;
            }
            if (ke.key == 257 && this.input.isKeyDown(257)) {
                this.entered = true;
            }
            if (!this.input.isKeyDown(currk = ke.key)) continue;
            switch (currk) {
                case 261: {
                    return "delete";
                }
                case 259: {
                    return "delete";
                }
                case 48: {
                    return "0";
                }
                case 49: {
                    return "1";
                }
                case 50: {
                    return "2";
                }
                case 51: {
                    return "3";
                }
                case 52: {
                    return "4";
                }
                case 53: {
                    return "5";
                }
                case 54: {
                    return "6";
                }
                case 55: {
                    return "7";
                }
                case 56: {
                    return "8";
                }
                case 57: {
                    return "9";
                }
            }
        }
        return null;
    }

    private void readConfig() {
        FileInputStream input = null;
        this.server_address = "127.0.0.1";
        this.server_port = 18668;
        this.nsserver_port = 18669;
        this.worldname = "my_world";
        this.playername = "Player";
        this.alt_texture_path = "";
        this.crypted_password = "";
        this.name_registered_already = false;
        try {
            input = new FileInputStream("DangerZone.properties");
            this.prop.load(input);
            this.server_address = this.getPropertyString(this.prop, "ServerAddress", "127.0.0.1");
            this.server_port = this.getPropertyInt(this.prop, "ServerPort", 0, Integer.MAX_VALUE, 18668);
            this.nsserver_port = this.getPropertyInt(this.prop, "NameServerPort", 0, Integer.MAX_VALUE, 18669);
            this.worldname = this.getPropertyString(this.prop, "WorldName", "my_world");
            this.playername = this.getPropertyString(this.prop, "Playername", "Player");
            this.alt_texture_path = this.getPropertyString(this.prop, "AltTextureDir", "");
            this.crypted_password = this.getPropertyString(this.prop, "CryptedPassword", "");
            this.name_registered_already = this.getPropertyBoolean(this.prop, "Registered", false);
            this.client_max_g = this.getPropertyInt(this.prop, "ClientMaxG", 1, 16, 2);
            this.single_max_g = this.getPropertyInt(this.prop, "SingleMaxG", 1, 16, 2);
            this.server_max_g = this.getPropertyInt(this.prop, "ServerMaxG", 1, 16, 2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (input != null) {
            try {
                ((InputStream)input).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void writeConfig() {
        FileOutputStream output = null;
        try {
            output = new FileOutputStream("DangerZone.properties");
            this.prop.setProperty("ServerAddress", this.server_address);
            this.prop.setProperty("ServerPort", String.format("%d", this.server_port));
            this.prop.setProperty("NameServerPort", String.format("%d", this.nsserver_port));
            this.prop.setProperty("WorldName", this.worldname);
            this.prop.setProperty("Playername", this.playername);
            this.prop.setProperty("AltTextureDir", this.alt_texture_path);
            this.prop.setProperty("CryptedPassword", this.crypted_password);
            this.prop.setProperty("Registered", this.name_registered_already ? "true" : "false");
            this.prop.setProperty("ClientMaxG", String.format("%d", this.client_max_g));
            this.prop.setProperty("SingleMaxG", String.format("%d", this.single_max_g));
            this.prop.setProperty("ServerMaxG", String.format("%d", this.server_max_g));
            this.prop.store(output, null);
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        if (output != null) {
            try {
                ((OutputStream)output).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void doHomeScreen() {
        this.textAt(25.0f, this.screen_height - 55, "Hi " + this.playername + "!");
        this.buttons = new ArrayList<ButtonHandler>();
        this.buttons.add(new ButtonHandler(25, this.screen_height - 155, 105, 45, this.runbuttontexture, "PLAY", 1));
        this.textAt(150.0f, this.screen_height - 155, ": " + this.worldname);
        this.buttons.add(new ButtonHandler(25, 100, 275, 45, this.buttontexture, "World Selection", 5));
        this.buttons.add(new ButtonHandler(this.input.getScreenWidth() - 250, 50, 215, 45, this.buttontexture, "Music Credits", 22));
        if (this.login_state == 0) {
            this.do_validate = true;
        }
        this.bb = this.buttons.iterator();
        while (this.bb.hasNext()) {
            this.bb.next().draw();
        }
        while (this.input.hasNextKey()) {
            Inputs.KeyEvent ke = this.input.nextKey();
            if (ke.key == 256 && this.input.isKeyDown(256) && ke.isdown) {
                this.quit = true;
                break;
            }
            if (ke.key == 88 && this.input.isKeyDown(88) && ke.isdown) {
                this.quit = true;
                break;
            }
            if (ke.key != 81 || !this.input.isKeyDown(81) || !ke.isdown) continue;
            this.quit = true;
            break;
        }
        while (this.input.mnext()) {
            Inputs.MouseEvent me = this.input.nextButton();
            if (me == null) continue;
            int clickx = (int)me.x;
            int clicky = (int)me.y;
            if (!me.isdown) continue;
            this.bb = this.buttons.iterator();
            ButtonHandler fb = null;
            while (this.bb.hasNext()) {
                ButtonHandler mb = this.bb.next();
                if (clickx < mb.x || clickx > mb.x + mb.xsize || clicky < mb.y || clicky > mb.y + mb.ysize) continue;
                fb = mb;
                break;
            }
            if (me.button == 0 && fb != null) {
                fb.leftclickhandler();
            }
            if (me.button != 1 || fb == null) continue;
            fb.rightclickhandler();
        }
    }

    public void doMusicScreen() {
        this.buttons = new ArrayList<ButtonHandler>();
        this.buttons.add(new ButtonHandler(25, this.screen_height - 55, 125, 45, this.buttontexture, "Back", 4));
        this.textAt(25.0f, this.screen_height - 150, "Music Credits:");
        this.smalltextAt(100.0f, this.screen_height - 250, "https://machinimasound.com");
        this.smalltextAt(100.0f, this.screen_height - 300, "Licensed under Creative Commons Attribution 4.0 International");
        this.smalltextAt(100.0f, this.screen_height - 350, "(http://creativecommons.org/licenses/by/4.0/)");
        this.smalltextAt(100.0f, this.screen_height - 400, "Authors: Machinimasound, Jens Kiilstofte, Per Kiilstofte, Aaron Spencer");
        this.bb = this.buttons.iterator();
        while (this.bb.hasNext()) {
            this.bb.next().draw();
        }
        while (this.input.mnext()) {
            Inputs.MouseEvent me = this.input.nextButton();
            if (me == null) continue;
            int clickx = (int)me.x;
            int clicky = (int)me.y;
            if (!me.isdown) continue;
            this.bb = this.buttons.iterator();
            ButtonHandler fb = null;
            while (this.bb.hasNext()) {
                ButtonHandler mb = this.bb.next();
                if (clickx < mb.x || clickx > mb.x + mb.xsize || clicky < mb.y || clicky > mb.y + mb.ysize) continue;
                fb = mb;
                break;
            }
            if (me.button == 0 && fb != null) {
                fb.leftclickhandler();
            }
            if (me.button != 1 || fb == null) continue;
            fb.rightclickhandler();
        }
    }

    public void doRegisterConfirm() {
        this.buttons = new ArrayList<ButtonHandler>();
        this.buttons.add(new ButtonHandler(25, this.screen_height - 55, 125, 45, this.buttontexture, "Back", 4));
        if (this.errstring != null) {
            this.errtextAt(25.0f, this.screen_height - 555, this.errstring);
        }
        this.textAt(25.0f, this.screen_height - 155, "Player Name:");
        this.textAt(225.0f, this.screen_height - 155, this.playername);
        this.textAt(25.0f, this.screen_height - 205, "Password:");
        this.textAt(225.0f, this.screen_height - 205, this.playerpassword);
        this.errstring = null;
        if (this.playerpassword.length() < 4) {
            this.errstring = "Password must be > 3 characters";
        }
        if (this.playerpassword.length() > 16) {
            this.errstring = "Password must be < 17 characters";
        }
        if (this.playername.length() < 4) {
            this.errstring = "Name must be > 3 characters";
        }
        if (this.playername.length() > 16) {
            this.errstring = "Name must be < 17 characters";
        }
        if (this.playername.toLowerCase().startsWith("player")) {
            this.errstring = "Name cannot start with \"Player\"";
        }
        if (this.errstring != null) {
            this.current_screen = 2;
            return;
        }
        this.textAt(25.0f, this.screen_height - 255, "Register this name and password?");
        this.buttons.add(new ButtonHandler(225, this.screen_height - 305, 85, 45, this.buttontexture, "YES", 32, 1.0f));
        this.buttons.add(new ButtonHandler(325, this.screen_height - 305, 65, 45, this.buttontexture, "NO", 33, 1.0f));
        this.bb = this.buttons.iterator();
        while (this.bb.hasNext()) {
            this.bb.next().draw();
        }
        while (this.input.mnext()) {
            Inputs.MouseEvent me = this.input.nextButton();
            if (me == null) continue;
            int clickx = (int)me.x;
            int clicky = (int)me.y;
            if (!me.isdown) continue;
            this.bb = this.buttons.iterator();
            ButtonHandler fb = null;
            while (this.bb.hasNext()) {
                ButtonHandler mb = this.bb.next();
                if (clickx < mb.x || clickx > mb.x + mb.xsize || clicky < mb.y || clicky > mb.y + mb.ysize) continue;
                fb = mb;
                break;
            }
            if (me.button == 0 && fb != null) {
                fb.leftclickhandler();
            }
            if (me.button != 1 || fb == null) continue;
            fb.rightclickhandler();
        }
    }

    public void doOptionsScreen() {
        int i;
        String newstring;
        this.buttons = new ArrayList<ButtonHandler>();
        this.buttons.add(new ButtonHandler(25, this.screen_height - 55, 125, 45, this.buttontexture, "Back", 4));
        if (this.errstring != null) {
            this.errtextAt(25.0f, this.screen_height - 555, this.errstring);
        }
        this.textAt(25.0f, this.screen_height - 155, "Player Name:");
        this.buttons.add(new ButtonHandler(225, this.screen_height - 155, 325, 45, this.textinputtexture, this.playername, 7, this.playernameinput ? 1.0f : 0.25f));
        this.textAt(25.0f, this.screen_height - 205, "Password:");
        this.buttons.add(new ButtonHandler(225, this.screen_height - 205, 325, 45, this.textinputtexture, this.playerpassword, 19, this.passwordinput ? 1.0f : 0.25f));
        if (!this.name_registered_already) {
            this.buttons.add(new ButtonHandler(25, this.screen_height - 405, 475, 45, this.runbuttontexture, "Register New Name/Password", 21));
        }
        this.textAt(25.0f, this.screen_height - 255, "Login State:");
        if (this.playerstatestring != null) {
            this.textAt(225.0f, this.screen_height - 255, this.playerstatestring);
        }
        this.buttons.add(new ButtonHandler(25, this.screen_height - 355, 250, 45, this.runbuttontexture, "Login", 20));
        this.bb = this.buttons.iterator();
        while (this.bb.hasNext()) {
            this.bb.next().draw();
        }
        String s = this.getTextChar();
        if (this.playernameinput) {
            if (this.entered) {
                this.playernameinput = false;
            }
            if (this.escaped) {
                this.playernameinput = false;
            }
            if (s != null) {
                if (!s.equals("delete")) {
                    if (!s.equals(" ") && this.playername.length() < 16) {
                        this.playername = String.valueOf(this.playername) + s;
                    }
                } else if (this.playername.length() > 0) {
                    newstring = new String();
                    i = 0;
                    while (i < this.playername.length() - 1) {
                        newstring = String.valueOf(newstring) + this.playername.charAt(i);
                        ++i;
                    }
                    this.playername = newstring;
                }
            }
        }
        if (this.passwordinput) {
            if (this.entered) {
                this.passwordinput = false;
                if (this.name_registered_already) {
                    this.do_validate = true;
                } else {
                    this.current_screen = 6;
                }
            }
            if (this.escaped) {
                this.passwordinput = false;
            }
            if (s != null) {
                if (!s.equals("delete")) {
                    if (this.playerpassword.length() < 16) {
                        this.playerpassword = String.valueOf(this.playerpassword) + s;
                    }
                } else if (this.playerpassword.length() > 0) {
                    newstring = new String();
                    i = 0;
                    while (i < this.playerpassword.length() - 1) {
                        newstring = String.valueOf(newstring) + this.playerpassword.charAt(i);
                        ++i;
                    }
                    this.playerpassword = newstring;
                }
            }
        }
        this.errstring = null;
        if (this.login_state != 1) {
            if (this.playerpassword.length() < 4) {
                this.errstring = "Password must be > 3 characters";
            }
            if (this.playerpassword.length() > 16) {
                this.errstring = "Password must be < 17 characters";
            }
            if (this.playername.length() < 4) {
                this.errstring = "Name must be > 3 characters";
            }
            if (this.playername.length() > 16) {
                this.errstring = "Name must be < 17 characters";
            }
            if (this.playername.toLowerCase().startsWith("player")) {
                this.errstring = "Name cannot start with \"Player\"";
            }
            this.current_screen = 2;
        }
        while (this.input.mnext()) {
            Inputs.MouseEvent me = this.input.nextButton();
            if (me == null) continue;
            int clickx = (int)me.x;
            int clicky = (int)me.y;
            if (!me.isdown) continue;
            this.bb = this.buttons.iterator();
            ButtonHandler fb = null;
            while (this.bb.hasNext()) {
                ButtonHandler mb = this.bb.next();
                if (clickx < mb.x || clickx > mb.x + mb.xsize || clicky < mb.y || clicky > mb.y + mb.ysize) continue;
                fb = mb;
                break;
            }
            if (me.button == 0 && fb != null) {
                fb.leftclickhandler();
            }
            if (me.button != 1 || fb == null) continue;
            fb.rightclickhandler();
        }
    }

    public void doMultiPlayerScreen() {
        int i;
        String newstring;
        this.buttons = new ArrayList<ButtonHandler>();
        this.buttons.add(new ButtonHandler(25, this.screen_height - 55, 125, 45, this.buttontexture, "Back", 4));
        this.textAt(25.0f, this.screen_height - 155, "Server Address:");
        this.buttons.add(new ButtonHandler(325, this.screen_height - 155, 325, 45, this.textinputtexture, this.server_address, 8, this.serveraddressinput ? 1.0f : 0.25f));
        this.textAt(25.0f, this.screen_height - 205, "Server Port:");
        this.server_port_string = String.format("%d", this.server_port);
        this.buttons.add(new ButtonHandler(325, this.screen_height - 205, 325, 45, this.textinputtexture, this.server_port_string, 9, this.serverportinput ? 1.0f : 0.25f));
        this.buttons.add(new ButtonHandler(25, this.screen_height - 305, 325, 45, this.runbuttontexture, "START A SERVER", 10));
        this.buttons.add(new ButtonHandler(25, this.screen_height - 255, 400, 45, this.runbuttontexture, "CONNECT TO SERVER", 11));
        this.bb = this.buttons.iterator();
        while (this.bb.hasNext()) {
            this.bb.next().draw();
        }
        String s = this.getTextChar();
        if (this.serveraddressinput) {
            if (this.entered) {
                this.serveraddressinput = false;
                if (this.server_address.length() <= 0) {
                    this.server_address = "127.0.0.1";
                }
            }
            if (this.escaped) {
                this.serveraddressinput = false;
            }
            if (s != null) {
                if (!s.equals("delete")) {
                    if (this.server_address.length() < 24) {
                        this.server_address = String.valueOf(this.server_address) + s;
                    }
                } else if (this.server_address.length() > 0) {
                    newstring = new String();
                    i = 0;
                    while (i < this.server_address.length() - 1) {
                        newstring = String.valueOf(newstring) + this.server_address.charAt(i);
                        ++i;
                    }
                    this.server_address = newstring;
                }
            }
        }
        if (this.serverportinput) {
            if (this.entered) {
                this.serverportinput = false;
                if (this.server_port_string.length() <= 0) {
                    this.server_port_string = "18668";
                }
            }
            if (this.escaped) {
                this.serverportinput = false;
            }
            if (s != null) {
                if (!s.equals("delete")) {
                    if (this.server_port_string.length() < 6) {
                        this.server_port_string = String.valueOf(this.server_port_string) + s;
                    }
                } else if (this.server_port_string.length() > 0) {
                    newstring = new String();
                    i = 0;
                    while (i < this.server_port_string.length() - 1) {
                        newstring = String.valueOf(newstring) + this.server_port_string.charAt(i);
                        ++i;
                    }
                    this.server_port_string = newstring;
                }
            }
            if (this.server_port_string.length() > 0) {
                this.server_port = Integer.parseInt(this.server_port_string);
            }
        }
        while (this.input.mnext()) {
            Inputs.MouseEvent me = this.input.nextButton();
            if (me == null) continue;
            int clickx = (int)me.x;
            int clicky = (int)me.y;
            if (!me.isdown) continue;
            this.bb = this.buttons.iterator();
            ButtonHandler fb = null;
            while (this.bb.hasNext()) {
                ButtonHandler mb = this.bb.next();
                if (clickx < mb.x || clickx > mb.x + mb.xsize || clicky < mb.y || clicky > mb.y + mb.ysize) continue;
                fb = mb;
                break;
            }
            if (me.button == 0 && fb != null) {
                fb.leftclickhandler();
            }
            if (me.button != 1 || fb == null) continue;
            fb.rightclickhandler();
        }
    }

    public void removedir(String dir) {
        File[] files;
        File[] fileArray = files = new File(dir).listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                this.removedir(String.valueOf(dir) + "/" + file.getName());
            } else {
                file.delete();
            }
            ++n2;
        }
        File curdir = new File(dir);
        curdir.delete();
    }

    public void doSinglePlayerScreen() {
        String curdir = System.getProperty("user.dir");
        File[] files = new File(String.valueOf(curdir) + "/worlds").listFiles();
        String currworldname = "";
        int newnumworld = 0;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                if (this.worldliststart == newnumworld) {
                    currworldname = file.getName();
                }
                ++newnumworld;
            }
            ++n2;
        }
        if (this.worldliststart >= newnumworld) {
            this.worldliststart = 0;
        }
        this.numworld = newnumworld;
        this.buttons = new ArrayList<ButtonHandler>();
        this.buttons.add(new ButtonHandler(25, this.screen_height - 55, 125, 45, this.buttontexture, "Back", 4));
        this.textAt(25.0f, this.screen_height - 155, "World:");
        this.textAt(175.0f, this.screen_height - 155, currworldname);
        if (currworldname != "") {
            this.worldname = currworldname;
        }
        this.buttons.add(new ButtonHandler(175, this.screen_height - 205, 100, 45, this.buttontexture, "Next", 12));
        this.buttons.add(new ButtonHandler(300, this.screen_height - 205, 100, 45, this.buttontexture, "Prev", 13));
        this.buttons.add(new ButtonHandler(425, this.screen_height - 205, 150, 45, this.buttontexture, "Edit", 23));
        this.buttons.add(new ButtonHandler(625, this.screen_height - 205, 150, 45, this.buttontexture, "Delete", 15));
        this.buttons.add(new ButtonHandler(25, this.screen_height - 305, 150, 45, this.buttontexture, "Create", 14));
        this.buttons.add(new ButtonHandler(225, this.screen_height - 305, 325, 45, this.textinputtexture, this.newworldname, 18, this.newworldinput ? 1.0f : 0.25f));
        if (this.displaydeleteconfirm) {
            this.textAt(200.0f, this.screen_height - 375, "Delete: " + this.worldname);
            this.textAt(200.0f, this.screen_height - 425, "Are you sure?");
            this.buttons.add(new ButtonHandler(425, this.screen_height - 425, 45, 45, this.checktexture, "", 16));
            this.buttons.add(new ButtonHandler(475, this.screen_height - 425, 45, 45, this.unchecktexture, "", 17));
        }
        this.bb = this.buttons.iterator();
        while (this.bb.hasNext()) {
            this.bb.next().draw();
        }
        String s = this.getTextChar();
        if (this.newworldinput) {
            if (this.entered) {
                this.newworldinput = false;
                if (this.newworldname.length() <= 0) {
                    this.newworldname = "New World";
                }
            }
            if (this.escaped) {
                this.newworldinput = false;
            }
            if (s != null) {
                if (!s.equals("delete")) {
                    if (this.newworldname.length() < 24) {
                        this.newworldname = String.valueOf(this.newworldname) + s;
                    }
                } else if (this.newworldname.length() > 0) {
                    String newstring = new String();
                    int i = 0;
                    while (i < this.newworldname.length() - 1) {
                        newstring = String.valueOf(newstring) + this.newworldname.charAt(i);
                        ++i;
                    }
                    this.newworldname = newstring;
                }
            }
        }
        while (this.input.mnext()) {
            Inputs.MouseEvent me = this.input.nextButton();
            if (me == null) continue;
            int clickx = (int)me.x;
            int clicky = (int)me.y;
            if (!me.isdown) continue;
            this.bb = this.buttons.iterator();
            ButtonHandler fb = null;
            while (this.bb.hasNext()) {
                ButtonHandler mb = this.bb.next();
                if (clickx < mb.x || clickx > mb.x + mb.xsize || clicky < mb.y || clicky > mb.y + mb.ysize) continue;
                fb = mb;
                break;
            }
            if (me.button == 0 && fb != null) {
                fb.leftclickhandler();
            }
            if (me.button != 1 || fb == null) continue;
            fb.rightclickhandler();
        }
    }

    public void doWorldEditScreen() {
        String curdir = System.getProperty("user.dir");
        this.worldfile = String.valueOf(curdir) + "/worlds/" + this.worldname + "/world.dat";
        this.buttons = new ArrayList<ButtonHandler>();
        this.buttons.add(new ButtonHandler(25, this.screen_height - 55, 125, 45, this.buttontexture, "Back", 4));
        this.textAt(25.0f, this.screen_height - 155, "World:");
        this.textAt(175.0f, this.screen_height - 155, this.worldname);
        if (!this.world_loaded) {
            this.loadWorld(this.worldfile);
        }
        this.textAt(50.0f, this.screen_height - 205, "Cave Generation:");
        this.buttons.add(new ButtonHandler(425, this.screen_height - 205, 45, 45, this.generatecaves ? this.checktexture : this.unchecktexture, "", 24));
        this.textAt(50.0f, this.screen_height - 255, "Play Nicely:");
        this.buttons.add(new ButtonHandler(425, this.screen_height - 255, 45, 45, this.playnicely ? this.checktexture : this.unchecktexture, "", 25));
        this.textAt(50.0f, this.screen_height - 305, "Keep Inventory:");
        this.buttons.add(new ButtonHandler(425, this.screen_height - 305, 45, 45, this.keep_inventory_on_death ? this.checktexture : this.unchecktexture, "", 31));
        this.textAt(50.0f, this.screen_height - 355, "Time of Day:");
        this.buttons.add(new ButtonHandler(425, this.screen_height - 355, 100, 45, this.textinputtexture, this.todinputstring, 27, this.todinput ? 1.0f : 0.25f));
        this.buttons.add(new ButtonHandler(50, this.screen_height - 515, 125, 45, this.buttontexture, "SAVE", 30));
        String s = this.getNumericChar();
        if (this.todinput) {
            if (this.entered) {
                this.todinput = false;
                if (this.todinputstring.length() <= 0) {
                    this.todinputstring = "0";
                }
            }
            if (this.escaped) {
                this.todinput = false;
            }
            if (s != null) {
                if (!s.equals("delete")) {
                    if (this.todinputstring.length() < 4) {
                        this.todinputstring = String.valueOf(this.todinputstring) + s;
                    }
                } else if (this.todinputstring.length() > 0) {
                    String newstring = new String();
                    int i = 0;
                    while (i < this.todinputstring.length() - 1) {
                        newstring = String.valueOf(newstring) + this.todinputstring.charAt(i);
                        ++i;
                    }
                    this.todinputstring = newstring;
                }
            }
            if (this.todinputstring.length() > 0) {
                this.timetimer = Integer.parseInt(this.todinputstring);
            }
        }
        this.bb = this.buttons.iterator();
        while (this.bb.hasNext()) {
            this.bb.next().draw();
        }
        while (this.input.mnext()) {
            Inputs.MouseEvent me = this.input.nextButton();
            if (me == null) continue;
            int clickx = (int)me.x;
            int clicky = (int)me.y;
            if (!me.isdown) continue;
            this.bb = this.buttons.iterator();
            ButtonHandler fb = null;
            while (this.bb.hasNext()) {
                ButtonHandler mb = this.bb.next();
                if (clickx < mb.x || clickx > mb.x + mb.xsize || clicky < mb.y || clicky > mb.y + mb.ysize) continue;
                fb = mb;
                break;
            }
            if (me.button == 0 && fb != null) {
                fb.leftclickhandler();
            }
            if (me.button != 1 || fb == null) continue;
            fb.rightclickhandler();
        }
    }

    public int getPropertyInt(Properties prop, String propname, int min, int max, int dflt) {
        int retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            retval = Integer.parseInt(s);
            if (retval < min) {
                retval = min;
            }
            if (retval > max) {
                retval = max;
            }
        }
        return retval;
    }

    public long getPropertyLong(Properties prop, String propname, long min, long max, long dflt) {
        long retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            retval = Long.parseLong(s);
            if (retval < min) {
                retval = min;
            }
            if (retval > max) {
                retval = max;
            }
        }
        return retval;
    }

    public float getPropertyFloat(Properties prop, String propname, float min, float max, float dflt) {
        float retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            retval = Float.parseFloat(s);
            if (retval < min) {
                retval = min;
            }
            if (retval > max) {
                retval = max;
            }
        }
        return retval;
    }

    public double getPropertyDouble(Properties prop, String propname, double min, double max, double dflt) {
        double retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            retval = Double.parseDouble(s);
            if (retval < min) {
                retval = min;
            }
            if (retval > max) {
                retval = max;
            }
        }
        return retval;
    }

    public boolean getPropertyBoolean(Properties prop, String propname, boolean dflt) {
        boolean retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            retval = Boolean.parseBoolean(s);
        }
        return retval;
    }

    public String getPropertyString(Properties prop, String propname, String dflt) {
        String retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            retval = s;
        }
        return retval;
    }

    public void addFile(File f) throws IOException {
        this.addURL(f.toURI().toURL());
    }

    public void addURL(URL u) throws IOException {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", this.parameters);
            method.setAccessible(true);
            method.invoke((Object)sysloader, u);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("Error, could not add URL to system classloader");
        }
    }

    public void doCryptPassword() {
        int namelen = this.playername.length();
        int passlen = this.playerpassword.length();
        String dzstring = "DangerZone is the best!";
        int dzstlen = dzstring.length();
        String hashbackstring = "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        int hashbacklen = hashbackstring.length();
        int[] nameint = new int[32];
        int[] passint = new int[32];
        int[] dzstint = new int[32];
        int[] cryptint = new int[32];
        if (namelen < 4 || passlen < 4) {
            this.errstring = "password encryption failure";
            return;
        }
        String tstring = this.playername.toLowerCase();
        byte[] asbytes = tstring.getBytes();
        int i = 0;
        while (i < 32) {
            nameint[i] = asbytes[i % namelen];
            ++i;
        }
        asbytes = this.playerpassword.getBytes();
        i = 0;
        while (i < 32) {
            passint[i] = asbytes[i % passlen];
            ++i;
        }
        asbytes = dzstring.getBytes();
        i = 0;
        while (i < 32) {
            dzstint[i] = asbytes[i % dzstlen];
            ++i;
        }
        i = 0;
        while (i < 32) {
            cryptint[i] = nameint[i] * passint[31 - i];
            int n = i;
            cryptint[n] = cryptint[n] / 8;
            int n2 = i;
            cryptint[n2] = cryptint[n2] * dzstint[i];
            int n3 = i;
            cryptint[n3] = cryptint[n3] / 4;
            int n4 = i;
            cryptint[n4] = cryptint[n4] + (nameint[i] ^ passint[i] ^ dzstint[i]);
            ++i;
        }
        i = 0;
        while (i < 32) {
            int n = i;
            cryptint[n] = cryptint[n] & 0xFFF;
            int j = cryptint[i];
            cryptint[i] = cryptint[cryptint[i] % 32];
            cryptint[cryptint[i] % 32] = j;
            ++i;
        }
        this.crypted_password = "";
        i = 0;
        while (i < 32) {
            this.crypted_password = String.valueOf(this.crypted_password) + hashbackstring.charAt(cryptint[i] % hashbacklen);
            ++i;
        }
    }

    public void loadWorld(String worldname) {
        FileInputStream input = null;
        Properties worldprop = new Properties();
        this.generatecaves = true;
        this.playnicely = false;
        this.keep_inventory_on_death = false;
        this.require_valid_passwords = true;
        this.default_privs = 0;
        this.max_players_on_server = 10;
        this.timetimer = 0;
        this.worldseed = System.currentTimeMillis();
        try {
            input = new FileInputStream(worldname);
            worldprop.load(input);
            this.timetimer = this.getPropertyInt(worldprop, "TimeOfDay", 0, Integer.MAX_VALUE, 0);
            this.generatecaves = this.getPropertyBoolean(worldprop, "CaveGeneration", true);
            this.playnicely = this.getPropertyBoolean(worldprop, "PlayNicely", false);
            this.keep_inventory_on_death = this.getPropertyBoolean(worldprop, "KeepInventory", false);
            this.require_valid_passwords = this.getPropertyBoolean(worldprop, "RequireValidPassword", true);
            this.default_privs = this.getPropertyInt(worldprop, "DefaultPrivs", Integer.MIN_VALUE, Integer.MAX_VALUE, 0);
            this.max_players_on_server = this.getPropertyInt(worldprop, "MaxPlayers", 2, 255, 10);
            this.worldseed = this.getPropertyLong(worldprop, "WorldSeed", Long.MIN_VALUE, Long.MAX_VALUE, this.worldseed);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.todinputstring = String.format("%d", this.timetimer);
        this.privsinputstring = String.format("%d", this.default_privs);
        this.maxpinputstring = String.format("%d", this.max_players_on_server);
        if (input != null) {
            try {
                ((InputStream)input).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.world_loaded = true;
    }

    public void saveWorld(String worldname) {
        Properties worldprop = new Properties();
        OutputStream output = null;
        File f = new File(worldname);
        f.getParentFile().mkdirs();
        try {
            worldprop.setProperty("TimeOfDay", String.format("%d", this.timetimer));
            worldprop.setProperty("CaveGeneration", String.format("%s", this.generatecaves ? "true" : "false"));
            worldprop.setProperty("PlayNicely", String.format("%s", this.playnicely ? "true" : "false"));
            worldprop.setProperty("KeepInventory", String.format("%s", this.keep_inventory_on_death ? "true" : "false"));
            worldprop.setProperty("RequireValidPassword", String.format("%s", this.require_valid_passwords ? "true" : "false"));
            worldprop.setProperty("DefaultPrivs", String.format("%d", this.default_privs));
            worldprop.setProperty("MaxPlayers", String.format("%d", this.max_players_on_server));
            worldprop.setProperty("WorldSeed", String.format("%d", this.worldseed));
            output = new FileOutputStream(worldname);
            worldprop.store(output, null);
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        if (output != null) {
            try {
                output.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public class ButtonHandler {
        Texture t;
        int x;
        int y;
        int xsize;
        int ysize;
        String s;
        int which;
        float transp;

        public ButtonHandler(int xpos, int ypos, int bxsize, int bysize, Texture tx, String ot, int b) {
            this.x = xpos;
            this.y = ypos;
            this.xsize = bxsize;
            this.ysize = bysize;
            this.t = tx;
            this.s = ot;
            this.which = b;
            this.transp = 1.0f;
        }

        public ButtonHandler(int xpos, int ypos, int bxsize, int bysize, Texture tx, String ot, int b, float tr) {
            this.x = xpos;
            this.y = ypos;
            this.xsize = bxsize;
            this.ysize = bysize;
            this.t = tx;
            this.s = ot;
            this.which = b;
            this.transp = tr;
        }

        public void leftclickhandler() {
            String where;
            ArrayList<String> cmdarray;
            String curdir;
            LauncherCode.this.popsound.playAsSoundEffect(1.0f, 1.0f, false);
            if (this.which == 1) {
                curdir = System.getProperty("user.dir");
                cmdarray = new ArrayList<String>();
                try {
                    cmdarray.add(Runnit.getJreExecutable().toString());
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    return;
                }
                LauncherCode.this.writeConfig();
                where = String.valueOf(curdir) + "/GameRunner.jar";
                cmdarray.add("-jar");
                cmdarray.add(where);
                cmdarray.add("singleplayer");
                cmdarray.add("-singleplayer");
                cmdarray.add("--singleplayer");
                try {
                    Runnit.launch("singleplayer", cmdarray);
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                }
                LauncherCode.this.stopGUI();
                System.exit(0);
            }
            if (this.which == 2) {
                LauncherCode.this.current_screen = 1;
            }
            if (this.which == 3) {
                LauncherCode.this.current_screen = 2;
            }
            if (this.which == 4) {
                if (LauncherCode.this.current_screen == 5) {
                    LauncherCode.this.current_screen = 3;
                    LauncherCode.this.world_loaded = false;
                    LauncherCode.this.todinput = false;
                    LauncherCode.this.privsinput = false;
                    LauncherCode.this.maxpinput = false;
                } else {
                    LauncherCode.this.current_screen = LauncherCode.this.current_screen == 6 ? 2 : 0;
                }
                LauncherCode.this.playernameinput = false;
                LauncherCode.this.serveraddressinput = false;
                LauncherCode.this.serverportinput = false;
                LauncherCode.this.displaydeleteconfirm = false;
                LauncherCode.this.newworldinput = false;
                LauncherCode.this.passwordinput = false;
            }
            if (this.which == 5) {
                LauncherCode.this.current_screen = 3;
            }
            if (this.which == 7) {
                LauncherCode.this.playernameinput = true;
                LauncherCode.this.passwordinput = false;
            }
            if (this.which == 8) {
                LauncherCode.this.serveraddressinput = true;
                LauncherCode.this.serverportinput = false;
            }
            if (this.which == 9) {
                LauncherCode.this.serverportinput = true;
                LauncherCode.this.serveraddressinput = false;
            }
            if (this.which == 10) {
                curdir = System.getProperty("user.dir");
                cmdarray = new ArrayList();
                try {
                    cmdarray.add(Runnit.getJreExecutable().toString());
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    return;
                }
                LauncherCode.this.writeConfig();
                where = String.valueOf(curdir) + "/GameRunner.jar";
                cmdarray.add("-jar");
                cmdarray.add(where);
                cmdarray.add("server");
                cmdarray.add("-server");
                cmdarray.add("--server");
                try {
                    Runnit.launch("server", cmdarray);
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
                LauncherCode.this.stopGUI();
                System.exit(0);
            }
            if (this.which == 11) {
                curdir = System.getProperty("user.dir");
                cmdarray = new ArrayList();
                try {
                    cmdarray.add(Runnit.getJreExecutable().toString());
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    return;
                }
                LauncherCode.this.writeConfig();
                where = String.valueOf(curdir) + "/GameRunner.jar";
                cmdarray.add("-jar");
                cmdarray.add(where);
                cmdarray.add("client");
                cmdarray.add("-client");
                cmdarray.add("--client");
                try {
                    Runnit.launch("client", cmdarray);
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
                LauncherCode.this.stopGUI();
                System.exit(0);
            }
            if (this.which == 12) {
                ++LauncherCode.this.worldliststart;
                if (LauncherCode.this.worldliststart >= LauncherCode.this.numworld) {
                    LauncherCode.this.worldliststart = LauncherCode.this.numworld - 1;
                }
                if (LauncherCode.this.worldliststart < 0) {
                    LauncherCode.this.worldliststart = 0;
                }
            }
            if (this.which == 13) {
                --LauncherCode.this.worldliststart;
                if (LauncherCode.this.worldliststart < 0) {
                    LauncherCode.this.worldliststart = 0;
                }
            }
            if (this.which == 14) {
                boolean files;
                LauncherCode.this.newworldinput = false;
                if (LauncherCode.this.newworldname != null && LauncherCode.this.newworldname != "" && !LauncherCode.this.newworldname.contains("..") && (files = new File(String.valueOf(curdir = System.getProperty("user.dir")) + "/worlds/" + LauncherCode.this.newworldname).mkdirs())) {
                    LauncherCode.this.newworldname = "New World";
                }
            }
            if (this.which == 15) {
                LauncherCode.this.displaydeleteconfirm = true;
            }
            if (this.which == 16) {
                LauncherCode.this.displaydeleteconfirm = false;
                if (LauncherCode.this.worldname != null && LauncherCode.this.worldname != "" && !LauncherCode.this.worldname.contains("..")) {
                    curdir = System.getProperty("user.dir");
                    LauncherCode.this.removedir(String.valueOf(curdir) + "/worlds/" + LauncherCode.this.worldname);
                }
            }
            if (this.which == 17) {
                LauncherCode.this.displaydeleteconfirm = false;
            }
            if (this.which == 18) {
                LauncherCode.this.newworldinput = true;
            }
            if (this.which == 19) {
                LauncherCode.this.passwordinput = true;
                LauncherCode.this.playernameinput = false;
            }
            if (this.which == 20) {
                if (LauncherCode.this.playerpassword.length() >= 4 && LauncherCode.this.playerpassword.length() <= 16 && LauncherCode.this.playername.length() >= 4 && LauncherCode.this.playername.length() <= 16) {
                    LauncherCode.this.crypted_password = "";
                    LauncherCode.this.doCryptPassword();
                    LauncherCode.this.playerpassword = "";
                }
                LauncherCode.this.passwordinput = false;
                LauncherCode.this.playernameinput = false;
                LauncherCode.this.do_validate = true;
            }
            if (this.which == 21) {
                if (LauncherCode.this.playerpassword.length() >= 4 && LauncherCode.this.playerpassword.length() <= 16 && LauncherCode.this.playername.length() >= 4 && LauncherCode.this.playername.length() <= 16) {
                    LauncherCode.this.crypted_password = "";
                    LauncherCode.this.doCryptPassword();
                }
                LauncherCode.this.passwordinput = false;
                LauncherCode.this.playernameinput = false;
                LauncherCode.this.do_validate = false;
                LauncherCode.this.current_screen = 6;
            }
            if (this.which == 22) {
                LauncherCode.this.current_screen = 4;
            }
            if (this.which == 23) {
                LauncherCode.this.current_screen = 5;
            }
            if (this.which == 24) {
                boolean bl = LauncherCode.this.generatecaves = !LauncherCode.this.generatecaves;
            }
            if (this.which == 25) {
                boolean bl = LauncherCode.this.playnicely = !LauncherCode.this.playnicely;
            }
            if (this.which == 26) {
                boolean bl = LauncherCode.this.require_valid_passwords = !LauncherCode.this.require_valid_passwords;
            }
            if (this.which == 27) {
                LauncherCode.this.todinput = true;
                LauncherCode.this.privsinput = false;
                LauncherCode.this.maxpinput = false;
            }
            if (this.which == 28) {
                LauncherCode.this.privsinput = true;
                LauncherCode.this.todinput = false;
                LauncherCode.this.maxpinput = false;
            }
            if (this.which == 29) {
                LauncherCode.this.maxpinput = true;
                LauncherCode.this.todinput = false;
                LauncherCode.this.privsinput = false;
            }
            if (this.which == 30) {
                LauncherCode.this.saveWorld(LauncherCode.this.worldfile);
            }
            if (this.which == 31) {
                boolean bl = LauncherCode.this.keep_inventory_on_death = !LauncherCode.this.keep_inventory_on_death;
            }
            if (this.which == 32) {
                LauncherCode.this.do_register = true;
                LauncherCode.this.current_screen = 2;
                LauncherCode.this.playerpassword = "";
            }
            if (this.which == 33) {
                LauncherCode.this.do_register = false;
                LauncherCode.this.current_screen = 2;
            }
        }

        public void rightclickhandler() {
        }

        public void draw() {
            if (this.t != null) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.transp);
                LauncherCode.this.drawRectangleWithTexture(this.t, this.x, this.y, this.xsize, this.ysize);
            }
            if (this.s != null && !this.s.equals("")) {
                LauncherCode.this.textAt(this.x + 6, this.y, this.s);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }
}

